$(document).ready(function() {
	//初始化设置：显示题型、试题的隐藏及首个显示；时间设置
	$(".bank_type_num").css("display","none");
	$(".bank").css("display","none");
	
	$(".bank_type_num_1").css("display","");
	$(".bank_1").css("display","");
	$(".bank_num_1").css("background","green");
	
	var restTime = parseInt($("#total_time").attr('value'))*60;
	setTime(restTime,0);
	
	//考生须知
	$(".paper_doc").click(function(){
		$("#productsMenu_zzjs").css("display","");
	});
	
	$(".hide_paper_doc").click(function(){
		$("#productsMenu_zzjs").css("display","none");
	});
	
	
	//试题跳转：跳转、题号点击、上一题、下一题
	$("#jump").click(function() {
		var bank_num_new = parseInt($("#jump_num").attr("value"));
		var bank_total = parseInt($("#info_bank_now").attr("bank_total"));
		
		if (isNaN(bank_num_new)) {
			alert("请输入要跳转的题号");
		} else if (bank_num_new > bank_total || bank_num_new <= 0) {
			alert("请输入存在的题号");
		} else {
			jump(bank_num_new);
		}
	});
	
	$(".bank_num").click(function() {
		var bank_num_new = parseInt($(this).attr("bank_num"));
		jump(bank_num_new);
	});
	
	$("#prev").click(function() {
		var bank_num_new = parseInt($("#info_bank_now").attr("bank_num"));
		if (bank_num_new == 1) {
			alert("已是最前一题");
		} else {
			bank_num_new -= 1;
			jump(bank_num_new);
		}
	});
	
	$("#next").click(function() {
		var bank_num_new = parseInt($("#info_bank_now").attr("bank_num"));
		var bank_total = parseInt($("#info_bank_now").attr("bank_total"));
		if (bank_num_new == bank_total) {
			alert("已是最后一题，如果要交卷，请点击“交卷”按钮");
		} else {
			bank_num_new += 1;
			jump(bank_num_new);
		}
	});
	
	//显示选择的答案并保存到session
	//单选、多选、判断
	$(".option").click(function() {
		var bank_num_now = $("#info_bank_now").attr("bank_num");
		var bank_id = $(this).attr("bank_id");
		
		var answer = '';
		$(".option_"+bank_id).each(function() {
			if ($(this).attr('checked') == true) {
				answer += $(this).attr("value");
			}
		});
		
		var undone_num = parseInt($("#undone_num").html());
		if (answer) {
			changeDoTag(bank_num_now,1);
			$("#show_"+bank_id).html(answer);
		} else {
			changeDoTag(bank_num_now,0);
			$("#show_"+bank_id).html('　');
		}
		
		answer = (answer == "正确")?1:((answer == "错误")?2:answer);
		saveAnswer(bank_id,answer);
	});
	
	//对于含有附件且做题时复制该的试题（word、excel），点击附件就认为其作答了该题
	$(".copy_annex_open").click(function() {
		var bank_id = $(this).attr("bank_id");
		var answer = $(this).attr("answer");
		
		var bank_num_now = $("#info_bank_now").attr("bank_num");
		changeDoTag(bank_num_now,1);
		
		saveAnswer(bank_id,answer);
	});
	//对于flash试题，在关闭flash时会调用examination()方法
	
	//windows
	
	
	//主观题
	$(".my_answer").click(function() {
		var bank_num_now = $("#info_bank_now").attr("bank_num");
		
		changeDoTag(bank_num_now,1);
		$(this).attr('this_do_tag',1);
		var bank_id = $(this).attr('bank_id');
		saveAnswer(bank_id,true);	//仅标记
	});
	
	
	//试卷提交
	$("#overIt").click(function() {		
		
		var undone_num = $("#undone_num").html();
		if (confirm("您有"+undone_num+"道题未做，确认要交卷吗？")) {
			//保存主观题
			var answer = '';
			var bank_id = '';
			$(".my_answer").each(function(){
				if ($(this).attr('this_do_tag') == 1)
				{
					answer = $(this).html();
					bank_id = $(this).attr('bank_id');
					saveAnswer(bank_id,answer);
				}
			});
			
			if (confirm("请您再次确认是否交卷！")) {
				if (confirm("请您最后确认是否交卷！")) {
					
					finishExam();
				}
			}
		}
	});
	
});

function jump(bank_num_new) {
	var bank_type_num_now = $("#info_bank_now").attr("bank_type_num");
	var bank_num_now = $("#info_bank_now").attr("bank_num");
	var bank_type_num_new = $(".bank_num_"+bank_num_new).attr("bank_type_num");
	
	$(".bank_num_"+bank_num_now).css("background","");
	$(".bank_num_"+bank_num_new).css("background","green");
	
	if (bank_type_num_now != bank_type_num_new) {
		$(".bank_type_num_"+bank_type_num_now).css("display","none");
		$(".bank_type_num_"+bank_type_num_new).css("display","");
	}
	$(".bank_"+bank_num_now).css("display","none");
	$(".bank_"+bank_num_new).css("display","");
	
	$("#info_bank_now").attr("bank_type_num",bank_type_num_new);
	$("#info_bank_now").attr("bank_num",bank_num_new);
	
	//保存答案：windows题
	var bank_type_en = $(".bank_num_"+bank_num_new).attr('bank_type_en');
	if (bank_type_en == 'windows')
	{
		changeDoTag(bank_num_new,1);
		var bank_id = $(".bank_num_"+bank_num_new).attr('bank_id');
		var answer = $(".windows_"+bank_id).attr("answer");
		saveAnswer(bank_id,answer);
	}
	
}


/**
 * 修改试题被做标记
 * @param bank_num	需修改的试题编号
 * @param tag		0：修改为未做；1：修改为已做。
 */
function changeDoTag(bank_num,tag) {
	var bank_type_en = $(".bank_num_"+bank_num).attr("bank_type_en");
	if (bank_type_en == 'BigSmall')
	{
		
	}
	
	var doTag = parseInt($(".bank_"+bank_num).attr("dotag"));
	if (doTag != tag)
	{
		var undone_num = parseInt($("#undone_num").html());
		if (doTag == 0)
		{
			$(".bank_num_color_"+bank_num).css('color','blue');
			$("#undone_num").html(undone_num-1);
		}
		else
		{
			$(".bank_num_color_"+bank_num).css('color','red');
			$("#undone_num").html(undone_num+1);
		}
		$(".bank_"+bank_num).attr('dotag',tag);
	}
}


function count(i,line,amount){
	if (i == 6) {
		i = 0;
		amount = "。";
	} else {
		amount = amount + line;
	}
	i++;
	$("#chart").html(amount);
	setTimeout(function() {count(i,line,amount);},500);
}

function showFlash(annex_name) {
	var obj = '<object id="obj" classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="800" height="600" align="middle">\
	<param name="allowScriptAccess" value="sameDomain" />\
	<param name="movie" value="/examnation/flash/' + annex_name + '" />\
	<param name="quality" value="high" />\
	<param name="wmode" value="opaque" />\
	<embed src="/examnation/flash/' + annex_name + '" width="300" height="480" align="middle" name="flash_wmp" bgcolor="#ece9d8" allowScriptAccess="sameDomain" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" />\
	</object>';
	
	$(".flash_bank").html(obj);
	$(".flash_bank").css("display","");
	
}
function examination(answer){
	var rs = answer.split("|");
	
	var bank_num_now = $("#info_bank_now").attr("bank_num");
	//修改试题被做标记
	changeDoTag(bank_num_now,1);
	//保存答案
	var bank_id = $(".flash_"+rs[0]).attr("bank_id");
	saveAnswer(bank_id,rs[1]);
	//隐藏flash
	$(".flash_bank").css("display","none");
	//跳到下一题
	$("#next_bank[id=next_bank]").click();
	
}